/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.enchant;

import lotr.common.item.LOTRItemAxe;
import lotr.common.item.LOTRItemBattleaxe;
import lotr.common.item.LOTRItemBlowgun;
import lotr.common.item.LOTRItemCommandSword;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemThrowingAxe;
import lotr.common.item.LOTRWeaponStats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;

public enum LOTREnchantmentType {
    BREAKABLE,
    UNBREAKABLE,
    ARMOR,
    ARMOR_FEET,
    ARMOR_LEGS,
    ARMOR_BODY,
    ARMOR_HEAD,
    MELEE,
    TOOL,
    AXE,
    SHEARS,
    RANGED,
    RANGED_LAUNCHER,
    RANGED_LAUNCHER2,
    THROWING_AXE,
    FISHING;


    public boolean canApply(ItemStack itemstack, boolean considering) {
        Item item = itemstack.func_77973_b();
        if (this == BREAKABLE && item.func_77645_m()) {
            return true;
        }
        if (this == UNBREAKABLE && item.func_77645_m()) {
            return false;
        }
        if (item instanceof ItemArmor && ((ItemArmor)item).field_77879_b > 0) {
            if (this == ARMOR) {
                return true;
            }
            ItemArmor itemarmor = (ItemArmor)item;
            int armorType = itemarmor.field_77881_a;
            if (armorType == 0) {
                return this == ARMOR_HEAD;
            }
            if (armorType == 1) {
                return this == ARMOR_BODY;
            }
            if (armorType == 1) {
                return this == ARMOR_BODY;
            }
            if (armorType == 2) {
                return this == ARMOR_LEGS;
            }
            if (armorType == 3) {
                return this == ARMOR_FEET;
            }
        }
        if (this == MELEE && LOTRWeaponStats.isMeleeWeapon(itemstack) && !(item instanceof LOTRItemCommandSword)) {
            return true;
        }
        if (this == TOOL && !item.getToolClasses(itemstack).isEmpty()) {
            return true;
        }
        if (this == AXE && (item instanceof LOTRItemAxe || item instanceof LOTRItemBattleaxe)) {
            return true;
        }
        if (this == SHEARS && item instanceof ItemShears) {
            return true;
        }
        if (this == RANGED && LOTRWeaponStats.isRangedWeapon(itemstack)) {
            return true;
        }
        if (this == RANGED_LAUNCHER && (item instanceof ItemBow || item instanceof LOTRItemCrossbow || item instanceof LOTRItemBlowgun)) {
            return true;
        }
        if (this == RANGED_LAUNCHER2 && (item instanceof ItemBow || item instanceof LOTRItemBlowgun)) {
            return true;
        }
        if (this == THROWING_AXE && item instanceof LOTRItemThrowingAxe) {
            return true;
        }
        return this == FISHING && item instanceof ItemFishingRod;
    }
}

